/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.InputDevice;
import javax.media.j3d.InputDeviceBlockingThread;
import javax.media.j3d.J3dThread;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.VirtualUniverse;

class InputDeviceScheduler
extends J3dThread {
    ArrayList nonBlockingDevices = new ArrayList(1);
    ArrayList blockingDevices = new ArrayList(1);
    ArrayList threads = new ArrayList(1);
    PhysicalEnvironment physicalEnv;
    Vector devices = new Vector(1);
    J3dThreadData threadData = new J3dThreadData();
    boolean active = false;
    static int samplingTime = 5;
    private static int numInstances = 0;
    private int instanceNum = -1;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputDeviceScheduler(ThreadGroup threadGroup, PhysicalEnvironment physicalEnvironment) {
        super(threadGroup);
        this.setName("J3D-InputDeviceScheduler-" + this.getInstanceNum());
        this.threadData.threadType = 4;
        this.threadData.thread = this;
        this.physicalEnv = physicalEnvironment;
        Vector vector = physicalEnvironment.devices;
        synchronized (vector) {
            Enumeration enumeration = physicalEnvironment.devices.elements();
            while (enumeration.hasMoreElements()) {
                this.addInputDevice((InputDevice)enumeration.nextElement());
            }
            physicalEnvironment.inputsched = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputDevice(InputDevice inputDevice) {
        switch (inputDevice.getProcessingMode()) {
            case 3: {
                InputDeviceBlockingThread inputDeviceBlockingThread = VirtualUniverse.mc.getInputDeviceBlockingThread(inputDevice);
                inputDeviceBlockingThread.start();
                ArrayList arrayList = this.blockingDevices;
                synchronized (arrayList) {
                    this.threads.add(inputDeviceBlockingThread);
                    this.blockingDevices.add(inputDevice);
                    break;
                }
            }
            case 4: {
                ArrayList arrayList = this.nonBlockingDevices;
                synchronized (arrayList) {
                    this.nonBlockingDevices.add(inputDevice);
                    if (this.active && this.nonBlockingDevices.size() == 1) {
                        VirtualUniverse.mc.addInputDeviceScheduler(this);
                    }
                    break;
                }
            }
            default: {
                for (int i2 = inputDevice.getSensorCount() - 1; i2 >= 0; --i2) {
                    inputDevice.getSensor((int)i2).demand_driven = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInputDevice(InputDevice inputDevice) {
        switch (inputDevice.getProcessingMode()) {
            case 3: {
                ArrayList arrayList = this.blockingDevices;
                synchronized (arrayList) {
                    int n2 = this.blockingDevices.indexOf(inputDevice);
                    InputDeviceBlockingThread inputDeviceBlockingThread = (InputDeviceBlockingThread)this.threads.remove(n2);
                    inputDeviceBlockingThread.finish();
                    this.blockingDevices.remove(n2);
                    break;
                }
            }
            case 4: {
                ArrayList arrayList = this.nonBlockingDevices;
                synchronized (arrayList) {
                    this.nonBlockingDevices.remove(this.nonBlockingDevices.indexOf(inputDevice));
                    if (this.active && this.nonBlockingDevices.size() == 0) {
                        VirtualUniverse.mc.removeInputDeviceScheduler(this);
                    }
                    break;
                }
            }
            default: {
                for (int i2 = inputDevice.getSensorCount() - 1; i2 >= 0; --i2) {
                    inputDevice.getSensor((int)i2).demand_driven = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() {
        if (!this.active) {
            this.active = true;
            ArrayList arrayList = this.nonBlockingDevices;
            synchronized (arrayList) {
                if (this.nonBlockingDevices.size() > 0) {
                    VirtualUniverse.mc.addInputDeviceScheduler(this);
                }
            }
            arrayList = this.blockingDevices;
            synchronized (arrayList) {
                for (int i2 = this.threads.size() - 1; i2 >= 0; --i2) {
                    ((InputDeviceBlockingThread)this.threads.get(i2)).restart();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        if (this.active) {
            ArrayList arrayList = this.nonBlockingDevices;
            synchronized (arrayList) {
                if (this.nonBlockingDevices.size() > 0) {
                    VirtualUniverse.mc.removeInputDeviceScheduler(this);
                }
            }
            arrayList = this.blockingDevices;
            synchronized (arrayList) {
                for (int i2 = this.threads.size() - 1; i2 >= 0; --i2) {
                    ((InputDeviceBlockingThread)this.threads.get(i2)).sleep();
                }
            }
            this.active = false;
        }
    }

    J3dThreadData getThreadData() {
        return this.threadData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork(long l2) {
        ArrayList arrayList = this.nonBlockingDevices;
        synchronized (arrayList) {
            for (int i2 = this.nonBlockingDevices.size() - 1; i2 >= 0; --i2) {
                ((InputDevice)this.nonBlockingDevices.get(i2)).pollAndProcessInput();
            }
        }
    }

    void shutdown() {
        for (int i2 = this.threads.size() - 1; i2 >= 0; --i2) {
            ((InputDeviceBlockingThread)this.threads.get(i2)).finish();
        }
        this.threads.clear();
        this.blockingDevices.clear();
        this.nonBlockingDevices.clear();
        this.devices.clear();
    }
}

